% Run mooring scenarios and plot profiles

% Mean speed

Ombai1;
velocity = [ 0      1.00;
            -200    0.50;
		    -250	0.50;
		    -400	0.50;
		    -750	0.30;
		    -1500   0.20;
            -2200   0.10];

% Files

checkFile = 'Ombai1Mean';
mooringFile = 'Ombai1';

runmoor;
depthMean = depth;
hdistMean = hdist;
nodesMean = fnodes;

% Plot mooring

plmoor4

% Max speed profile

Ombai1;
velocity = [ 0      2.00;
            -200    1.50;
		    -250	1.50;
		    -400	0.80;
		    -750	0.60;
		    -1500   0.40;
            -2200   0.40];

% Print file

checkFile = 'Ombai1Max';

runmoor;
depthMax = depth;
hdistMax = hdist;
nodesMax = fnodes;

% Plot

figure(4);
clf
plot(hdistMean, -1. * depthMean, '-', 'linewidth', 1);
hold on
plot(hdistMax, -1. * depthMax, '-', 'linewidth', 1);
axis equal
set(gca, 'ylim', [0 -1*depthMax(1)]);
set(gca, 'xlim', [0 1500]);

text(nodesMean(end, 9), -1. * nodesMean(end, 5), ...
    [' ' num2str(-1. * nodesMean(end, 5), '%.0f')]);

text(nodesMax(end, 9), -1. * nodesMax(end, 5), ...
    [' ' num2str(-1. * nodesMax(end, 5), '%.0f')]);

for i=['nodesMean'; 'nodesMax ']'
   eval(['adcp = find(' i' '(:, 1) == 321);']);
   eval (['plot(' i' '(adcp,9),-1.*' i' '(adcp,5), ''bo'',''markerfacecolor'',''b'');']);
   eval (['text(' i' '(adcp,9),-1.*' i' '(adcp,5), num2str(-1.*' i' '(adcp,5),''%.0f''));']);
   eval(['rcms=find(' i' '(:,1)==308);']);
   eval (['plot(' i' '(rcms,9),-1.*' i' '(rcms,5), ''r<'',''markersize'',7)']);
end

set(gca, 'ydir', 'reverse');
xlabel('Horizontal Excursion (m)', 'fontsize', 12);
ylabel('Depth (m)', 'fontsize', 12);
set(gca, 'fontsize', 12, 'linewidth', 1);








